package io.maxads.ads.base.util;

import android.support.annotation.NonNull;

import java.util.concurrent.TimeUnit;

import io.maxads.ads.base.MaxAds;
import io.reactivex.Observable;

public class Helpers {
  public static class IntervalFactory {
    @NonNull
    public Observable<Long> createInterval(long delay, long period, @NonNull TimeUnit timeUnit) {
      return Observable.interval(delay, period, timeUnit);
    }
  }

  public static class TimerFactory {
    @NonNull
    public Observable<Long> createTimerSeconds(long timeSeconds) {
      return Observable.timer(timeSeconds, TimeUnit.SECONDS);
    }

    @NonNull
    public Observable<Long> createTimerMs(long timeMs) {
      return Observable.timer(timeMs, TimeUnit.MILLISECONDS);
    }
  }

  public static class SystemTimeHelper {
    public long currentTimeMillis() {
      return System.currentTimeMillis();
    }
  }

  public static class InitializationHelper {
    public boolean isInitialized() {
      return Checks.NoThrow.checkArgument(MaxAds.areModulesInitialized(), "One or more MAX SDK modules have not " +
        "been initialized. Please see error logs for details.");
    }
  }
}
