package io.maxads.ads.base.mraid;

import android.annotation.SuppressLint;
import android.content.Context;
import android.webkit.WebView;

/**
 * Created by emorypetermann on 3/22/16.
 */

@SuppressLint("ViewConstructor")
public class MRAIDBanner extends MRAIDView {

  public MRAIDBanner(Context context,
                     String baseUrl,
                     String[] supportedNativeFeatures,
                     MRAIDViewListener viewListener,
                     MRAIDNativeFeatureListener nativeFeatureListener) {
    super(context, baseUrl, supportedNativeFeatures, viewListener, nativeFeatureListener, false);
  }

  @Override
  public boolean onBackPressed() {
    return state != STATE_DEFAULT && super.onBackPressed();
  }

  @Override
  protected void close() {
    if (state == STATE_LOADING || state == STATE_DEFAULT || state == STATE_HIDDEN) {
      return;
    }
    super.close();
  }

  @Override
  protected void expand(String url) {
    // The only time it is valid to call expand on a banner ad is
    // when the ad is currently in either default or resized state.
    if (state != STATE_DEFAULT && state != STATE_RESIZED) {
      return;
    }

    super.expand(url);
  }

  @Override
  protected void expandHelper(WebView webView) {
    state = STATE_EXPANDED;
    super.expandHelper(webView);
    this.fireStateChangeEvent();
  }

  @Override
  protected void onLayoutCompleted() {
    if (state == STATE_LOADING && isPageFinished) {
      state = STATE_DEFAULT;
      fireStateChangeEvent();
      fireReadyEvent();
      if (isViewable) {
        fireViewableChangeEvent();
      }
    }
  }
}
