package io.maxads.ads.base.location;

import android.support.annotation.NonNull;

public enum LocationTrackingStatus {
  // app developer has not enabled location tracking
  DISABLED("disabled"),
  // device user has not authorized the app to collect location data
  UNAUTHORIZED("unauthorized"),
  // app developer has enabled location tracking and the device user has authorized the app to collect location data
  ENABLED("enabled");

  @NonNull private final String mStatus;

  LocationTrackingStatus(@NonNull String status) {
    mStatus = status;
  }

  @Override
  public String toString() {
    return mStatus;
  }
}
