package io.maxads.ads.base.location;

import android.location.Location;
import android.support.annotation.NonNull;

import io.maxads.ads.base.util.Optional;
import io.reactivex.Observable;

public class EmptyLocationProvider implements LocationProvider {
  @Override
  public void startLocationUpdates() {
  }

  @Override
  public void stopLocationUpdates() {
  }

  @NonNull
  @Override
  public Observable<Optional<Location>> getLastLocationAndStartUpdates() {
    return Observable.just(Optional.<Location>empty());
  }

  @Override
  public boolean hasPermission() {
    return false;
  }
}
