package io.maxads.ads.interstitial.view;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import io.maxads.ads.base.Constants;
import io.maxads.ads.base.mraid.MRAIDInterstitial;
import io.maxads.ads.base.mraid.MRAIDNativeFeatureListener;
import io.maxads.ads.base.mraid.MRAIDView;
import io.maxads.ads.base.mraid.MRAIDViewListener;

public class MraidInterstitialViewModuleImpl implements MraidInterstitialViewModule, MRAIDViewListener,
  MRAIDNativeFeatureListener {
  @NonNull private final Activity mActivity;
  @NonNull private final String[] mSupportedNativeFeatures;
  @Nullable private MRAIDInterstitial mMRAIDInterstitial;
  @Nullable private Listener mListener;

  public MraidInterstitialViewModuleImpl(@NonNull Activity activity) {
    mActivity = activity;
    mSupportedNativeFeatures = new String[]{};
  }

  @Override
  public void setListener(@Nullable Listener listener) {
    mListener = listener;
  }

  @Override
  public void load(long broadcastId, @NonNull String html) {
    mMRAIDInterstitial = new MRAIDInterstitial(mActivity, Constants.MAXADS_URL, mSupportedNativeFeatures, this, this);
    mMRAIDInterstitial.load(html, broadcastId);
  }

  @Override
  public void show() {
    if (mMRAIDInterstitial != null) {
      mMRAIDInterstitial.show(mActivity);
    }
  }

  @Override
  public void destroy() {
    if (mMRAIDInterstitial != null) {
      mMRAIDInterstitial.destroy();
    }
  }

  // MRAIDViewListener

  @Override
  public void mraidViewLoaded(MRAIDView mraidView) {
    if (mListener != null) {
      mListener.onLoaded();
    }
  }

  @Override
  public void mraidViewExpand(MRAIDView mraidView) {
    if (mListener != null) {
      mListener.onExpanded();
    }
  }

  @Override
  public void mraidViewClose(MRAIDView mraidView) {
    if (mListener != null) {
      mListener.onClosed();
    }
  }

  @Override
  public boolean mraidViewResize(MRAIDView mraidView, int width, int height, int offsetX, int offsetY) {
    return false;
  }

  // MRAIDNativeFeatureListener

  @Override
  public void mraidNativeFeatureCallTel(String url) {

  }

  @Override
  public void mraidNativeFeatureCreateCalendarEvent(String eventJSON) {

  }

  @Override
  public void mraidNativeFeaturePlayVideo(String url) {

  }

  @Override
  public void mraidNativeFeatureOpenBrowser(String url) {
    if (mListener != null) {
      mListener.onClicked(url);
    }
  }

  @Override
  public void mraidNativeFeatureStorePicture(String url) {

  }

  @Override
  public void mraidNativeFeatureSendSms(String url) {

  }
}
