package io.maxads.ads.interstitial.vast3.view;

import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public interface VASTViewModule {
  interface Listener {
    void onMediaPlayerPrepared(@NonNull MediaPlayer mediaPlayer);
    void onMediaPlayerCompletion(@NonNull MediaPlayer mediaPlayer);
    void onMediaPlayerError(@NonNull MediaPlayer mediaPlayer, int what, int extra);
    void onVideoClicked();
    void onCloseButtonClicked();
  }

  void setListener(@Nullable Listener listener);
  void showCountdownTimer();
  void hideCountdownTimer();
  void updateCountdownTimer(int totalTimeMs, int progressMs);
  void showCloseButton();
  void setVideoPath(@NonNull String url);
  void setVideoClickable(boolean clickable);
  void startVideo();
  void stopVideo();
  void videoSeekTo(int positionMs);
  boolean videoIsPlaying();
  int videoGetCurrentPositionMs();
  int videoGetDurationMs();
  void showLastVideoFrame(@NonNull Bitmap bitmap);
}
