package io.maxads.ads.interstitial.vast3.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import io.maxads.ads.interstitial.vast3.xml_model.TrackingXml;

public abstract class VASTTracker implements Serializable {
  private static final long serialVersionUID = 0L;
  @NonNull public static final String TAG = VASTTracker.class.getSimpleName();

  @NonNull
  public static List<VASTTracker> from(@Nullable List<TrackingXml> trackingXmls) {
    if (trackingXmls == null) {
      return Collections.emptyList();
    }

    final List<VASTTracker> vastTrackers = new ArrayList<>(trackingXmls.size());
    for (TrackingXml trackingXml : trackingXmls) {

      if (TextUtils.isEmpty(trackingXml.value)) {
        continue;
      }

      final VASTEventTracker vastEventTracker = VASTEventTracker.from(trackingXml);
      if (vastEventTracker != null) {
        vastTrackers.add(vastEventTracker);
        continue;
      }

      final VASTAbsoluteTracker vastAbsoluteTracker = VASTAbsoluteTracker.from(trackingXml);
      if (vastAbsoluteTracker != null) {
        vastTrackers.add(vastAbsoluteTracker);
        continue;
      }

      final VASTFractionalTracker vastFractionalTracker = VASTFractionalTracker.from(trackingXml);
      if (vastFractionalTracker != null) {
        vastTrackers.add(vastFractionalTracker);
      }
    }

    return vastTrackers;
  }

  @NonNull private final String mUrl;
  private boolean mIsTracked;

  public VASTTracker(@NonNull String url) {
    mUrl = url.trim();
  }

  @NonNull
  public String getUrl() {
    return mUrl;
  }

  public boolean isTracked() {
    return mIsTracked;
  }

  public void setTracked() {
    mIsTracked = true;
  }

  abstract public boolean isRepeatable();

  /**
   * Auto generated by Android Studio
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof VASTTracker)) return false;

    final VASTTracker that = (VASTTracker) o;

    return mUrl.equals(that.mUrl);
  }
}
