package io.maxads.ads.interstitial.vast3.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import io.maxads.ads.base.util.MaxAdsLog;
import io.maxads.ads.interstitial.vast3.xml_model.TrackingXml;

public class VASTEventTracker extends VASTTracker {
  @NonNull public static final String TAG = VASTEventTracker.class.getSimpleName();

  public enum Event {
    impression(false),
    error(true),
    click(false),
    creativeView(false),
    complete(false),
    pause(true),
    resume(true),
    close(false),
    closeLinear(false);

    private final boolean mIsRepeatable;

    Event(boolean isRepeatable) {
      mIsRepeatable = isRepeatable;
    }

    public boolean isRepeatable() {
      return mIsRepeatable;
    }
  }

  @Nullable
  public static VASTEventTracker from(@NonNull TrackingXml trackingXml) {
    try {
      return new VASTEventTracker(trackingXml.value, Event.valueOf(trackingXml.event));
    } catch (Exception e) {
      MaxAdsLog.d(TAG, "Unable to create vast event tracker from event: " + trackingXml.event);
      return null;
    }
  }

  @NonNull
  public static List<VASTTracker> from(@Nullable String url, @NonNull Event event) {
    return from(url != null ? Collections.singletonList(url) : Collections.<String>emptyList(), event);
  }

  @NonNull
  public static List<VASTTracker> from(@Nullable List<String> urls, @NonNull Event event) {
    if (urls == null) {
      return Collections.emptyList();
    }

    final List<VASTTracker> vastTrackers = new ArrayList<>(urls.size());
    for (String url : urls) {
      vastTrackers.add(new VASTEventTracker(url, event));
    }
    return vastTrackers;
  }

  @NonNull private final Event mEvent;

  public VASTEventTracker(@NonNull String url, @NonNull Event event) {
    super(url);
    mEvent = event;
  }

  @NonNull
  public Event getEvent() {
    return mEvent;
  }

  @Override
  public boolean isRepeatable() {
    return mEvent.isRepeatable();
  }

  /**
   * Auto generated by Android Studio
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;

    final VASTEventTracker that = (VASTEventTracker) o;

    return mEvent == that.mEvent;
  }
}
