package io.maxads.ads.interstitial.vast3;

import android.support.annotation.NonNull;

import io.maxads.ads.interstitial.vast3.model.VASTOffset;
import io.maxads.ads.interstitial.vast3.model.VASTVideoConfig;
import io.maxads.ads.interstitial.vast3.view.VASTViewModule;

public class VASTUITimerListener implements VASTTimer.Listener {

  @NonNull private final VASTViewModule mVASTViewModule;
  @NonNull private final VASTVideoConfig mVASTVideoConfig;

  public VASTUITimerListener(@NonNull VASTViewModule vastViewModule, @NonNull VASTVideoConfig vastVideoConfig) {
    mVASTViewModule = vastViewModule;
    mVASTVideoConfig = vastVideoConfig;
  }

  @Override
  public void onTick(int videoDurationMs, int currentPositionMs) {
    final VASTOffset skipOffset = mVASTVideoConfig.getSkipOffset();
    if (currentPositionMs > skipOffset.getOffsetForVideoMs(videoDurationMs)) {
      mVASTVideoConfig.setVideoCloseable(true);
      mVASTViewModule.showCloseButton();
      mVASTViewModule.setVideoClickable(true);
    }

    final int newVideoDurationMs = mVASTVideoConfig.getNewVideoDurationMs(videoDurationMs);
    mVASTViewModule.updateCountdownTimer(newVideoDurationMs, currentPositionMs);
    mVASTViewModule.showCountdownTimer();
  }

  @Override
  public void onStopped(int videoDurationMs, boolean videoCompleted, boolean maxDurationExceeded) {
    mVASTViewModule.hideCountdownTimer();
  }

  @Override
  public void onMaxDurationExceeded() {
  }
}
