package io.maxads.ads.interstitial.vast3;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import io.maxads.ads.base.util.Util;

public class VASTMacroDataImpl implements VASTMacroData {
  @Nullable private final VASTError mVASTError;
  @Nullable private final Integer mContentPlayHead;
  @Nullable private final String mAssetUri;

  @NonNull
  public static VASTMacroData from(@Nullable VASTError vastError) {
    return new Builder().withVASTError(vastError).build();
  }

  private VASTMacroDataImpl(Builder builder) {
    mVASTError = builder.mVASTError;
    mContentPlayHead = builder.mContentPlayHead;
    mAssetUri = builder.mAssetUri;
  }

  @Nullable
  @Override
  public VASTError getVASTError() {
    return mVASTError;
  }

  @Nullable
  @Override
  public Integer getContentPlayhead() {
    return mContentPlayHead;
  }

  @Nullable
  @Override
  public String getAssetUri() {
    return mAssetUri;
  }

  /**
   * Auto generated by Android Studio
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VASTMacroDataImpl that = (VASTMacroDataImpl) o;
    return mVASTError == that.mVASTError &&
      Util.equals(mContentPlayHead, that.mContentPlayHead) &&
      Util.equals(mAssetUri, that.mAssetUri);
  }

  public static class Builder {
    @Nullable private VASTError mVASTError;
    @Nullable private Integer mContentPlayHead;
    @Nullable private String mAssetUri;

    @NonNull
    public Builder withVASTError(@Nullable VASTError vastError) {
      mVASTError = vastError;
      return this;
    }

    @NonNull
    public Builder withContentPlayHead(@Nullable Integer contentPlayHead) {
      mContentPlayHead = contentPlayHead;
      return this;
    }

    @NonNull
    public Builder withAssetUri(@Nullable String assetUri) {
      mAssetUri = assetUri;
      return this;
    }

    @NonNull
    public VASTMacroDataImpl build() {
      return new VASTMacroDataImpl(this);
    }
  }
}
