package io.maxads.ads.interstitial.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.Window;
import android.view.WindowManager;

import io.maxads.ads.base.util.MaxAdsLog;
import io.maxads.ads.interstitial.InterstitialBroadcastSender;
import io.maxads.ads.interstitial.presenter.MraidInterstitialPresenter;
import io.maxads.ads.interstitial.view.MraidInterstitialViewModule;
import io.maxads.ads.interstitial.view.MraidInterstitialViewModuleImpl;

/**
 * Dedicated activity to display MRAID interstitials
 */
public class MraidInterstitialActivity extends Activity implements MraidInterstitialPresenter.Listener {
  @NonNull public static final String TAG = MraidInterstitialActivity.class.getSimpleName();

  @NonNull public static final String HTML_KEY = "html_key";
  @NonNull public static final String BROADCAST_ID_KEY = "broadcast_id_key";

  @Nullable private MraidInterstitialPresenter mMraidInterstitialPresenter;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    // hide title bar of application
    requestWindowFeature(Window.FEATURE_NO_TITLE);
    // hide status bar of Android
    getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

    getWindow().setFlags(WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED,
      WindowManager.LayoutParams.FLAG_HARDWARE_ACCELERATED);

    final Intent intent = getIntent();
    final String html = intent.getStringExtra(HTML_KEY);
    final long broadcastId = intent.getLongExtra(BROADCAST_ID_KEY, -1);

    if (TextUtils.isEmpty(html)) {
      MaxAdsLog.w(TAG, "Unable to show MRAID interstitial, creative was empty");
      finish();
      return;
    }

    final MraidInterstitialViewModule mraidInterstitialViewModule = new MraidInterstitialViewModuleImpl(this);
    mMraidInterstitialPresenter = new MraidInterstitialPresenter(this, mraidInterstitialViewModule, html,
      new InterstitialBroadcastSender(this, broadcastId));
    mMraidInterstitialPresenter.setListener(this);
    mMraidInterstitialPresenter.show();
  }

  @Override
  public void onBackPressed() {
    super.onBackPressed();
    if (mMraidInterstitialPresenter != null) {
      mMraidInterstitialPresenter.onBackPressed();
    }
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();
    if (mMraidInterstitialPresenter != null) {
      mMraidInterstitialPresenter.destroy();
    }
  }

  @Override
  public void onClosed() {
    finish();
  }
}
