package io.maxads.ads.interstitial;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;

import io.maxads.ads.base.util.MaxAdsLog;

public class InterstitialState {
  private static final String TAG = InterstitialState.class.getSimpleName();

  public enum State {
    IDLE,
    LOADING,
    READY,
    SHOWING,
    DESTROYED
  }

  @NonNull private final String mTag;
  @NonNull private volatile State mState;

  public InterstitialState() {
    this(TAG);
  }

  public InterstitialState(@NonNull String tag) {
    mTag = tag;
    mState = State.IDLE;
  }

  @NonNull
  public synchronized State getState() {
    return mState;
  }

  public synchronized boolean transitionState(@NonNull State endState) {
    switch (mState) {
      case IDLE:
        switch (endState) {
          case IDLE:
            mState = State.IDLE;
            return true;
          case LOADING:
            mState = State.LOADING;
            return true;
          case READY:
            return false;
          case SHOWING:
            logState();
            return false;
          case DESTROYED:
            mState = State.DESTROYED;
            return true;
        }
      case LOADING:
        switch (endState) {
          case IDLE:
            mState = State.IDLE;
            return true;
          case LOADING:
            logState();
            return false;
          case READY:
            mState = State.READY;
            return true;
          case SHOWING:
            logState();
            return false;
          case DESTROYED:
            mState = State.DESTROYED;
            return true;
        }
      case READY:
        switch (endState) {
          case IDLE:
            mState = State.IDLE;
            return true;
          case LOADING:
            logState();
            return false;
          case READY:
            return false;
          case SHOWING:
            mState = State.SHOWING;
            return true;
          case DESTROYED:
            mState = State.DESTROYED;
            return true;
        }
      case SHOWING:
        switch (endState) {
          case IDLE:
            mState = State.IDLE;
            return true;
          case LOADING:
            logState();
            return false;
          case READY:
            return false;
          case SHOWING:
            logState();
            return false;
          case DESTROYED:
            mState = State.DESTROYED;
            return true;
        }
      case DESTROYED:
        logState();
        return false;
      default:
        return false;
    }
  }

  public synchronized void logState() {
    MaxAdsLog.d(mTag, "Interstitial is " + mState.toString().toLowerCase());
  }

  @Deprecated
  @VisibleForTesting
  synchronized void setState(@NonNull State state) {
    mState = state;
  }
}
