package io.maxads.ads.base.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;

import io.maxads.ads.base.api.WinnerResponse;

public class Winner {
  public enum CreativeType {
    HTML,
    VAST3,
    EMPTY;

    @NonNull
    public static CreativeType from(@Nullable String creativeType) {
      if ("html".equalsIgnoreCase(creativeType)) {
        return HTML;
      } else if ("vast3".equalsIgnoreCase(creativeType)) {
        return VAST3;
      } else {
        return EMPTY;
      }
    }
  }

  @NonNull private final CreativeType mCreativeType;
  @Nullable private final String mPartner;
  @Nullable private final String mPartnerPlacementId;
  private final boolean mUsePartnerRendering;
  @Nullable private final Integer mWinningPrice;

  @NonNull
  public static Winner from(@Nullable WinnerResponse winnerResponse) {
    if (winnerResponse == null) {
      return new Winner(CreativeType.from(null), null, null, false, 0);
    }

    return new Winner(CreativeType.from(winnerResponse.creativeType), winnerResponse.partner,
      winnerResponse.partnerPlacementId, winnerResponse.usePartnerRendering, winnerResponse.winningPrice);
  }

  @VisibleForTesting
  public Winner(@NonNull CreativeType creativeType,
                @Nullable String partner,
                @Nullable String partnerPlacementId,
                @Nullable Boolean usePartnerRendering,
                @Nullable Integer winningPrice) {
    mCreativeType = creativeType;
    mPartner = partner != null ? partner : "";
    mPartnerPlacementId = partnerPlacementId != null ? partnerPlacementId : "";
    mUsePartnerRendering = usePartnerRendering != null && usePartnerRendering;
    mWinningPrice = winningPrice;
  }

  @NonNull
  public CreativeType getCreativeType() {
    return mCreativeType;
  }

  @NonNull
  public String getPartner() {
    return mPartner;
  }

  @NonNull
  public String getPartnerPlacementId() {
    return mPartnerPlacementId;
  }

  public boolean usePartnerRendering() {
    return mUsePartnerRendering;
  }

  @Nullable
  public Integer getWinningPrice() {
    return mWinningPrice;
  }
}
