package io.maxads.ads.base.api;

import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;

// TODO (steffan): add tests
public class TokenManager {
  @NonNull private final List<TokenProvider> mTokenProviders;
  @NonNull private final Map<String, String> mTokens;
  private boolean mTokensGenerated;

  public TokenManager() {
    mTokenProviders = new ArrayList<>();
    mTokens = new HashMap<>();
  }

  public void registerTokenProvider(@NonNull TokenProvider tokenProvider) {
    mTokenProviders.add(tokenProvider);
  }

  @NonNull
  public Observable<Map<String, String>> getOrGenerateTokens() {
    return mTokensGenerated ? Observable.just(mTokens) : generateTokens();
  }

  @NonNull
  private Observable<Map<String, String>> generateTokens() {
    final List<TokenProvider> tokenProviders = new ArrayList<>(mTokenProviders);
    return Observable.defer(new Callable<ObservableSource<Map<String, String>>>() {
      @Override
      public ObservableSource<Map<String, String>> call() {
        final Map<String, String> tokens = new HashMap<>(tokenProviders.size());
        for (TokenProvider tokenProvider : tokenProviders) {
          tokens.put(tokenProvider.getTokenId(), tokenProvider.getToken());
        }
        return Observable.just(tokens);
      }
    }).subscribeOn(Schedulers.computation())
      .observeOn(AndroidSchedulers.mainThread())
      .map(new Function<Map<String, String>, Map<String, String>>() {
        @Override
        public Map<String, String> apply(Map<String, String> tokens) {
          mTokens.clear();
          mTokens.putAll(tokens);
          mTokensGenerated = true;
          return tokens;
        }
      });
  }
}
