package io.maxads.ads.base.api;

import android.support.annotation.NonNull;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.HashMap;
import java.util.Map;

import io.maxads.ads.base.Session;

public class SessionRequest {
  public static class SessionScoresRequest {
    @SerializedName("max_score")
    @Expose
    @NonNull public final Integer mMaxSessionDepth;

    @SerializedName("ssp_score")
    @Expose
    @NonNull public final Integer mSSPSessionDepth;

    public SessionScoresRequest(@NonNull Integer maxSessionDepth, @NonNull Integer sspSessionDepth) {
      mMaxSessionDepth = maxSessionDepth;
      mSSPSessionDepth = sspSessionDepth;
    }
  }

  @SerializedName("id")
  @Expose
  @NonNull private final String mId;

  @SerializedName("scores")
  @Expose
  @NonNull private final Map<String, SessionScoresRequest> mSessionScoresRequestMap;

  public SessionRequest(@NonNull Session session) {
    mId = session.getSessionId();

    final Map<String, Session.SessionDepthScores> sessionDepthScoresMap = session.getSessionDepthScoresMap();
    mSessionScoresRequestMap = new HashMap<>(sessionDepthScoresMap.size());

    for (Map.Entry<String, Session.SessionDepthScores> entry : sessionDepthScoresMap.entrySet()) {
      final Session.SessionDepthScores value = entry.getValue();
      mSessionScoresRequestMap.put(entry.getKey(),
        new SessionScoresRequest(value.maxSessionDepth, value.sspSessionDepth));
    }
  }
}
