package io.maxads.ads.base;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Session {
  public static class SessionDepthScores {
    public int maxSessionDepth;
    public int sspSessionDepth;

    /**
     * Auto generated by Android Studio
     */
    @Override
    public boolean equals(Object o) {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;

      SessionDepthScores that = (SessionDepthScores) o;

      if (maxSessionDepth != that.maxSessionDepth) return false;
      return sspSessionDepth == that.sspSessionDepth;
    }
  }

  private final String mSessionId;
  @NonNull private final Map<String, SessionDepthScores> mSessionDepthScoresMap;

  public Session() {
    this(UUID.randomUUID().toString());
  }

  @VisibleForTesting
  public Session(@NonNull String sessionId) {
    mSessionId = sessionId;
    mSessionDepthScoresMap = new HashMap<>();
  }

  public String getSessionId() {
    return mSessionId;
  }

  @NonNull
  public Map<String, SessionDepthScores> getSessionDepthScoresMap() {
    return mSessionDepthScoresMap;
  }

  public void incrementMaxSessionDepth(@NonNull String adUnitId) {
    if (!mSessionDepthScoresMap.containsKey(adUnitId)) {
      mSessionDepthScoresMap.put(adUnitId, new SessionDepthScores());
    }

    mSessionDepthScoresMap.get(adUnitId).maxSessionDepth++;
  }

  public void incrementSSPSessionDepth(@NonNull String adUnitId) {
    if (!mSessionDepthScoresMap.containsKey(adUnitId)) {
      mSessionDepthScoresMap.put(adUnitId, new SessionDepthScores());
    }

    mSessionDepthScoresMap.get(adUnitId).sspSessionDepth++;
  }

  public int getSumOfSessionScores() {
    int sum = 0;
    for (SessionDepthScores sessionDepthScores : mSessionDepthScoresMap.values()) {
      sum += sessionDepthScores.maxSessionDepth;
      sum += sessionDepthScores.sspSessionDepth;
    }

    return sum;
  }
}
