package io.maxads.ads.base;

import android.support.annotation.NonNull;

import java.util.concurrent.TimeUnit;

import io.maxads.ads.interstitial.MaxInterstitial;

public class Constants {
  @NonNull public static final String API_VERSION = "1";
  @NonNull public static final String SDK_VERSION = "1.6.0";
  @NonNull public static final String HOST = "ads.maxads.io";
  @NonNull public static final String MAXADS_URL = "https://" + HOST + "/";

  /**
   * Default maximum amount of time for the length of a VAST video
   */
  public static final int DEFAULT_VAST_MAX_DURATION_MS = (int) TimeUnit.SECONDS.toMillis(60);

  /**
   * Default amount of time a user must wait before they are able to interact with or skip a VAST video
   */
  public static final int DEFAULT_VAST_SKIP_OFFSET_MS = (int) TimeUnit.SECONDS.toMillis(5);

  /**
   * Default time limit for interstitials to complete their loading phase. If an interstitial exceeds this limit,
   * the {@link io.maxads.ads.interstitial.MaxInterstitial.Listener#onInterstitialFailedToLoad(MaxInterstitial)}
   * callback will be invoked and the interstitial destroyed.
   */
  public static final int DEFAULT_INTERSTITIAL_LOAD_TIMEOUT_MS = (int) TimeUnit.SECONDS.toMillis(30);
}
