package io.maxads.ads.interstitial.vast3.view;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import io.maxads.ads.base.Constants;
import io.maxads.ads.base.view.HtmlWebView;

public class VASTIconViewModuleImpl implements VASTIconViewModule, View.OnClickListener {
  @NonNull private final HtmlWebView mIcon;
  @Nullable private Listener mListener;

  public VASTIconViewModuleImpl(@NonNull HtmlWebView icon) {
    mIcon = icon;
    mIcon.setOnClickListener(this);
    mIcon.setWebViewClient(new WebViewClient() {
      @Override
      public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (mListener != null) {
          mListener.onIconClicked(url);
        }
        return true;
      }
    });
  }

  @Override
  public void setListener(@Nullable Listener listener) {
    mListener = listener;
  }

  @Override
  public void loadIcon(@Nullable String html, int widthPx, int heightPx) {
    if (html == null) {
      return;
    }

    mIcon.loadDataWithBaseURL(Constants.MAXADS_URL, html, "text/html", "utf-8", null);
    mIcon.getLayoutParams().width = widthPx;
    mIcon.getLayoutParams().height = heightPx;
    mIcon.requestLayout();
  }

  @Override
  public void showIcon() {
    mIcon.setVisibility(View.VISIBLE);
  }

  @Override
  public void hideIcon() {
    mIcon.setVisibility(View.GONE);
  }

  @Override
  public void onClick(View v) {
    if (mListener == null) {
      return;
    }

    if (v == mIcon) {
      mListener.onIconClicked(null);
    }
  }
}
