package io.maxads.ads.interstitial.vast3.presenter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;

import io.maxads.ads.base.UrlHandlerDelegate;
import io.maxads.ads.interstitial.vast3.VASTApiClientDecorator;
import io.maxads.ads.interstitial.vast3.model.VASTCompanionAdConfig;
import io.maxads.ads.interstitial.vast3.model.VASTResource;
import io.maxads.ads.interstitial.vast3.view.VASTCompanionAdViewModule;

public class VASTCompanionAdPresenterImpl implements VASTCompanionAdPresenter, VASTCompanionAdViewModule.Listener {
  @NonNull private final VASTCompanionAdViewModule mVASTCompanionAdViewModule;
  @NonNull private final VASTCompanionAdConfig mVASTCompanionAdConfig;
  @NonNull private final VASTApiClientDecorator mVASTApiClientDecorator;
  @NonNull private final UrlHandlerDelegate mUrlHandlerDelegate;

  public VASTCompanionAdPresenterImpl(@NonNull Context context,
                                      @NonNull VASTCompanionAdViewModule vastCompanionAdViewModule,
                                      @NonNull VASTCompanionAdConfig vastCompanionAdConfig,
                                      @NonNull VASTApiClientDecorator vastApiClientDecorator) {
    this(vastCompanionAdViewModule, vastCompanionAdConfig, vastApiClientDecorator, new UrlHandlerDelegate(context));
  }

  @VisibleForTesting
  VASTCompanionAdPresenterImpl(@NonNull VASTCompanionAdViewModule vastCompanionAdViewModule,
                               @NonNull VASTCompanionAdConfig vastCompanionAdConfig,
                               @NonNull VASTApiClientDecorator vastApiClientDecorator,
                               @NonNull UrlHandlerDelegate urlHandlerDelegate) {
    mVASTCompanionAdViewModule = vastCompanionAdViewModule;
    mVASTCompanionAdViewModule.setListener(this);
    mVASTCompanionAdConfig = vastCompanionAdConfig;
    mVASTApiClientDecorator = vastApiClientDecorator;
    mUrlHandlerDelegate = urlHandlerDelegate;
  }

  public void loadCompanionAd() {
    mVASTCompanionAdViewModule.loadCompanionAd(mVASTCompanionAdConfig.getHtmlPayload(),
      mVASTCompanionAdConfig.getScaledWidthPx(), mVASTCompanionAdConfig.getScaledHeightPx());
  }

  public void showCompanionAd() {
    mVASTCompanionAdViewModule.showCompanionAd();
    mVASTApiClientDecorator.fireVASTTrackers(mVASTCompanionAdConfig.getCreativeViewTrackers());
  }

  @Override
  public void onCompanionAdClicked(@Nullable String webViewClickThroughUrl) {
    mVASTApiClientDecorator.fireVASTTrackers(mVASTCompanionAdConfig.getClickTrackers());

    // Static image companion ads must use the clickthrough url from the VAST XML
    final VASTResource vastResource = mVASTCompanionAdConfig.getVASTResource();
    if (vastResource.getType().equals(VASTResource.Type.StaticResource)
      && vastResource.getCreativeType().equals(VASTResource.CreativeType.IMAGE)) {
      mUrlHandlerDelegate.handleUrl(mVASTCompanionAdConfig.getClickThroughUrl());

    } else if (webViewClickThroughUrl != null){
      // HTML and iFrame based companion ads are capable of providing their own click through urls
      mUrlHandlerDelegate.handleUrl(webViewClickThroughUrl);
    }
  }
}

