package io.maxads.ads.interstitial.vast3.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import io.maxads.ads.base.util.MaxAdsLog;
import io.maxads.ads.interstitial.vast3.xml_model.TrackingXml;

public class VASTFractionalTracker extends VASTTracker implements Comparable<VASTFractionalTracker> {
  @NonNull public static final String TAG = VASTFractionalTracker.class.getSimpleName();

  public enum Event {
    start,
    midpoint,
    firstQuartile,
    thirdQuartile,
    progress
  }

  @Nullable
  public static VASTFractionalTracker from(@NonNull TrackingXml trackingXml) {
    float fraction = 0;
    try {
      switch (Event.valueOf(trackingXml.event)) {
        case start:
          fraction = 0;
          break;
        case firstQuartile:
          fraction = 0.25f;
          break;
        case midpoint:
          fraction = 0.5f;
          break;
        case thirdQuartile:
          fraction = 0.75f;
          break;
        case progress:
          final VASTOffset vastOffset = VASTOffset.from(trackingXml.offset);
          if (vastOffset == null || vastOffset.getOffsetFraction() == null) {
            return null;
          }
          fraction = vastOffset.getOffsetFraction();
          break;
      }
    } catch (Exception e) {
      MaxAdsLog.d(TAG, "Unable to create vast fractional tracker from event: " + trackingXml.event);
      return null;
    }

    return new VASTFractionalTracker(trackingXml.value, fraction);
  }

  private final float mFraction;

  public VASTFractionalTracker(@NonNull String url, float fraction) {
    super(url);
    mFraction = fraction;
  }

  @Override
  public boolean isRepeatable() {
    return false;
  }

  public float getFraction() {
    return mFraction;
  }

  /**
   * Auto generated by Android Studio
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;

    final VASTFractionalTracker that = (VASTFractionalTracker) o;

    return Float.compare(that.mFraction, mFraction) == 0;
  }

  @Override
  public int compareTo(@NonNull VASTFractionalTracker o) {
    return Float.compare(mFraction, o.mFraction);
  }
}
