package io.maxads.ads.interstitial.vast3.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import io.maxads.ads.base.util.MaxAdsLog;
import io.maxads.ads.base.util.Util;
import io.maxads.ads.interstitial.vast3.xml_model.TrackingXml;

public class VASTAbsoluteTracker extends VASTTracker implements Comparable<VASTAbsoluteTracker> {
  @NonNull public static final String TAG = VASTFractionalTracker.class.getSimpleName();

  public enum Event {
    progress
  }

  @Nullable
  public static VASTAbsoluteTracker from(@NonNull TrackingXml trackingXml) {
    if (!Util.enumContainsValue(Event.class, trackingXml.event)) {
      MaxAdsLog.d(TAG, "Unable to create vast absolute tracker from event: " + trackingXml.event);
      return null;
    }

    final VASTOffset vastOffset = VASTOffset.from(trackingXml.offset);
    if (vastOffset == null || vastOffset.getOffsetMs() == null) {
      return null;
    }

    return new VASTAbsoluteTracker(trackingXml.value, vastOffset.getOffsetMs());
  }

  private final int mTimeMs;

  public VASTAbsoluteTracker(@NonNull String url, int timeMs) {
    super(url);
    mTimeMs = timeMs;
  }

  @Override
  public boolean isRepeatable() {
    return false;
  }

  public int getTimeMs() {
    return mTimeMs;
  }

  /**
   * Auto generated by Android Studio
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;

    final VASTAbsoluteTracker that = (VASTAbsoluteTracker) o;

    return mTimeMs == that.mTimeMs;
  }

  @Override
  public int compareTo(@NonNull VASTAbsoluteTracker o) {
    return Util.compare(mTimeMs, o.mTimeMs);
  }
}
