package io.maxads.ads.interstitial.vast3;

import android.support.annotation.NonNull;

public enum VASTError {
  XML_PARSING_ERROR("100", "VAST XML parsing error"),

  /**
   * Video player expecting a different size
   */
  INCORRECT_SIZE("203", "VAST invalid size"),

  /**
   * Timeout of VAST URI provided in Wrapper element, or of VAST URI provided in a subsequent Wrapper element.
   * (URI was either unavailable or reached a timeout)
   */
  WRAPPER_TIMEOUT("301", "VAST wrapper timeout"),

  /**
   * Wrapper limit reached, as defined by the video player.
   * Too many Wrapper responses have been received with no InLine response.
   */
  WRAPPER_LIMIT_REACHED("302", "VAST wrapper limit reached"),

  /**
   * Video player is unable to display the Linear Ad
   */
  GENERAL_LINEAR_AD_ERROR("400", "VAST general linear ad error"),

  /**
   * Unable to find Linear/MediaFile from URI
   */
  MEDIA_FILE_NOT_FOUND("401", "VAST media file not found"),

  /**
   * Couldn’t find a MediaFile that is supported by this video player, based on the attributes of the MediaFile element
   */
  INVALID_MEDIA_FILE_TYPE("403", "VAST invalid media file type"),
  GENERAL_COMPANION_AD_ERROR("600", "VAST general companion ad error"),
  UNDEFINED_ERROR("900", "VAST undefined error");

  @NonNull private final String mErrorCode;
  @NonNull private final String mErrorMessage;

  VASTError(@NonNull String errorCode, @NonNull String errorMessage) {
    mErrorCode = errorCode;
    mErrorMessage = errorMessage;
  }

  @NonNull
  public String getErrorCode() {
    return mErrorCode;
  }

  @NonNull
  public String getErrorMessage() {
    return mErrorMessage;
  }

  public boolean isPlaybackError() {
    return this == GENERAL_LINEAR_AD_ERROR;
  }

  @Override
  public String toString() {
    return "VASTError{" +
      "mErrorCode='" + mErrorCode + '\'' +
      ", mErrorMessage='" + mErrorMessage + '\'' +
      '}';
  }
}
