package io.maxads.ads.interstitial.presenter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;

import io.maxads.ads.base.UrlHandlerDelegate;
import io.maxads.ads.interstitial.InterstitialBroadcastReceiver;
import io.maxads.ads.interstitial.InterstitialBroadcastSender;
import io.maxads.ads.interstitial.view.MraidInterstitialViewModule;

public class MraidInterstitialPresenter implements MraidInterstitialViewModule.Listener {
  public interface Listener {
    void onClosed();
  }

  @NonNull private final MraidInterstitialViewModule mMraidInterstitialViewModule;
  @NonNull private final String mHtml;
  @NonNull private final InterstitialBroadcastSender mInterstitialBroadcastSender;
  @NonNull private final UrlHandlerDelegate mUrlHandlerDelegate;

  @Nullable private Listener mListener;

  public MraidInterstitialPresenter(@NonNull Context context,
                                    @NonNull MraidInterstitialViewModule viewModule,
                                    @NonNull String html,
                                    @NonNull InterstitialBroadcastSender interstitialBroadcastSender) {
    this(viewModule, html, interstitialBroadcastSender, new UrlHandlerDelegate(context));
  }

  @VisibleForTesting
  MraidInterstitialPresenter(@NonNull MraidInterstitialViewModule viewModule,
                             @NonNull String html,
                             @NonNull InterstitialBroadcastSender interstitialBroadcastSender,
                             @NonNull UrlHandlerDelegate urlHandlerDelegate) {
    mMraidInterstitialViewModule = viewModule;
    mMraidInterstitialViewModule.setListener(this);
    mHtml = html;
    mInterstitialBroadcastSender = interstitialBroadcastSender;
    mUrlHandlerDelegate = urlHandlerDelegate;
  }

  public void setListener(@Nullable Listener listener) {
    mListener = listener;
  }

  public void show() {
    mMraidInterstitialViewModule.load(mInterstitialBroadcastSender.getBroadcastId(), mHtml);
  }

  public void onBackPressed() {
    onClosed();
  }

  public void destroy() {
    mMraidInterstitialViewModule.destroy();
  }

  @Override
  public void onLoaded() {
    mInterstitialBroadcastSender.sendBroadcast(InterstitialBroadcastReceiver.Action.SHOW);
    mMraidInterstitialViewModule.show();
  }

  @Override
  public void onExpanded() {
    mInterstitialBroadcastSender.sendBroadcast(InterstitialBroadcastReceiver.Action.IMPRESSED);
  }

  @Override
  public void onClosed() {
    mInterstitialBroadcastSender.sendBroadcast(InterstitialBroadcastReceiver.Action.DISMISS);
    if (mListener != null) {
      mListener.onClosed();
    }
  }

  @Override
  public void onClicked(@NonNull String url) {
    mInterstitialBroadcastSender.sendBroadcast(InterstitialBroadcastReceiver.Action.CLICK);
    mUrlHandlerDelegate.handleUrl(url);
  }
}
