package io.maxads.ads.interstitial;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.LocalBroadcastManager;

// TODO test
public class InterstitialBroadcastSender {
  private final long mBroadcastId;
  @NonNull private final LocalBroadcastManager mLocalBroadcastManager;

  public InterstitialBroadcastSender(@NonNull Context context, long broadcastId) {
    this(broadcastId, LocalBroadcastManager.getInstance(context));
  }

  @VisibleForTesting
  InterstitialBroadcastSender(long broadcastId, @NonNull LocalBroadcastManager localBroadcastManager) {
    mBroadcastId = broadcastId;
    mLocalBroadcastManager = localBroadcastManager;
  }

  public long getBroadcastId() {
    return mBroadcastId;
  }

  public void sendBroadcast(@NonNull InterstitialBroadcastReceiver.Action action) {
    final Intent intent = new Intent(action.getId());
    intent.putExtra(InterstitialBroadcastReceiver.BROADCAST_ID, mBroadcastId);
    mLocalBroadcastManager.sendBroadcast(intent);
  }
}
