package io.maxads.ads.base.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.util.AttributeSet;

import io.maxads.ads.base.WebViewClickDetector;

public class HtmlWebView extends MaxAdsWebView {
  public HtmlWebView(@NonNull Context context) {
    this(context, null);
  }

  @SuppressLint("SetJavaScriptEnabled")
  public HtmlWebView(Context context, AttributeSet attrs) {
    super(context, attrs);

    disableScrollingAndZoom();
    getSettings().setJavaScriptEnabled(true);
    enablePlugins(true);
    setBackgroundColor(Color.TRANSPARENT);
    setOnTouchListener(new WebViewClickDetector(this));
  }

  @Override
  public boolean performClick() {
    return super.performClick();
  }
}
