package io.maxads.ads.base.mraid.view;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;

import io.maxads.ads.base.view.MaxAdsWebView;

/**
 * Web view created to specifically work well with the Nexage open source MRAID 2.0 Android library
 */
public class MraidWebView extends MaxAdsWebView {
  public interface Listener {
    void onLayout(@NonNull MraidWebView mraidWebView, boolean changed, int left, int top, int right, int bottom);
    void onConfigurationChanged(@NonNull MraidWebView mraidWebView, Configuration newConfig);
    void onVisibilityChanged(@NonNull MraidWebView mraidWebView, View changedView, int visibility);
    void onWindowVisibilityChanged(@NonNull MraidWebView mraidWebView, int visibility);
  }

  @Nullable private Listener mListener;

  public MraidWebView(Context context) {
    super(context.getApplicationContext());

    disableScrollingAndZoom();
    setScrollContainer(false);
    enableJavascriptCaching();
    enablePlugins(false);

    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
      getSettings().setMediaPlaybackRequiresUserGesture(false);
    }

    setBackgroundColor(Color.BLACK);
  }

  public void setListener(@Nullable Listener listener) {
    mListener = listener;
  }

  @Override
  protected void onLayout(boolean changed, int l, int t, int r, int b) {
    super.onLayout(changed, l, t, r, b);
    if (mListener != null) {
      mListener.onLayout(this, changed, l, t, r, b);
    }
  }

  @Override
  protected void onConfigurationChanged(Configuration newConfig) {
    super.onConfigurationChanged(newConfig);
    if (mListener != null) {
      mListener.onConfigurationChanged(this, newConfig);
    }
  }

  @Override
  protected void onVisibilityChanged(View changedView, int visibility) {
    super.onVisibilityChanged(changedView, visibility);
    if (mListener != null) {
      mListener.onVisibilityChanged(this, changedView, visibility);
    }
  }

  @Override
  protected void onWindowVisibilityChanged(int visibility) {
    super.onWindowVisibilityChanged(visibility);
    if (mListener != null) {
      mListener.onWindowVisibilityChanged(this, visibility);
    }
  }

  @Override
  public boolean performClick() {
    return super.performClick();
  }
}
