package io.maxads.ads.base.mraid.view;

import android.support.annotation.NonNull;
import android.util.Base64;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

import io.maxads.ads.base.mraid.Assets;

/**
 * WebView client used for loading and caching HTML before notifying the publisher that the interstitial
 * is ready to be shown
 */
public class MraidCacheWebViewClient extends WebViewClient {
  @Override
  public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
    return url.contains("mraid.js")
      ? new WebResourceResponse("application/javascript", "UTF-8", getMraidJsStream())
      : super.shouldInterceptRequest(view, url);
  }

  @NonNull
  private InputStream getMraidJsStream() {
    final byte[] mraidjsBytes = Base64.decode(Assets.mraidJS, Base64.DEFAULT);
    final String mraidJs = new String(mraidjsBytes);
    return new ByteArrayInputStream(mraidJs.getBytes(Charset.forName("UTF-8")));
  }
}
