package io.maxads.ads.base.mraid;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.webkit.WebView;

@SuppressLint("ViewConstructor")
public class MRAIDInterstitial extends MRAIDView {

  public MRAIDInterstitial(Context context,
                           String baseUrl,
                           String[] supportedNativeFeatures,
                           MRAIDViewListener viewListener,
                           MRAIDNativeFeatureListener nativeFeatureListener) {
    super(context, baseUrl, supportedNativeFeatures, viewListener, nativeFeatureListener, true);
  }

  @Override
  protected void expand(String url) {
    // only expand interstitials from loading state
    if (state != STATE_LOADING) {
      return;
    }

    super.expand(url);
  }

  @Override
  protected void expandHelper(WebView webView) {
    super.expandHelper(webView);
    isLaidOut = true;
    state = STATE_DEFAULT;
    this.fireStateChangeEvent();
  }

  @Override
  protected void closeFromExpanded() {
    if (state == STATE_DEFAULT) {
      state = STATE_HIDDEN;
      clearView();
      handler.post(new Runnable() {
        @Override
        public void run() {
          fireStateChangeEvent();
          if (listener != null) {
            listener.mraidViewClose(MRAIDInterstitial.this);
          }
        }
      });
    }

    super.closeFromExpanded();
  }

  public void show(Activity activity) {
    this.showAsInterstitial(activity);
  }
}
