package io.maxads.ads.base.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;

import io.reactivex.Observable;
import okio.BufferedSource;

public interface MaxDiskLruCache {
  @WorkerThread boolean put(@NonNull String key, @NonNull BufferedSource bufferedSource);
  @NonNull Observable<Void> putAsync(@Nullable final String key, @NonNull final BufferedSource bufferedSource, long sizeBytes);
  boolean containsKey(@Nullable String key);
  @NonNull String getFilePath(@Nullable String key);
}
