package io.maxads.ads.base.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;

import io.reactivex.Observable;
import okio.BufferedSource;

public class EmptyDiskLruCache implements MaxDiskLruCache {
  @WorkerThread
  @Override
  public boolean put(@NonNull String key, @NonNull BufferedSource bufferedSource) {
    return false;
  }

  @NonNull
  @Override
  public Observable<Void> putAsync(@Nullable String key, @NonNull BufferedSource bufferedSource, long sizeBytes) {
    return Observable.error(new Exception("EmptyDiskLruCache"));
  }

  @Override
  public boolean containsKey(@Nullable String key) {
    return false;
  }

  @NonNull
  @Override
  public String getFilePath(@Nullable String key) {
    return "";
  }
}
