package io.maxads.ads.base.api;

import android.support.annotation.Nullable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class LocationRequest {
  @SerializedName("latitude")
  @Expose
  @Nullable private final Double mLatitude;

  @SerializedName("longitude")
  @Expose
  @Nullable private final Double mLongitude;

  @SerializedName("timestamp")
  @Expose
  @Nullable private final String mTimestamp;

  @SerializedName("horizontal_accuracy")
  @Expose
  @Nullable private final Double mHorizontalAccuracy;

  @SerializedName("vertical_accuracy")
  @Expose
  @Nullable private final Double mVerticalAccuracy;

  public LocationRequest(@Nullable Double latitude, @Nullable Double longitude, @Nullable String timestamp,
                         @Nullable Double horizontalAccuracy, @Nullable Double verticalAccuracy) {
    mLatitude = latitude;
    mLongitude = longitude;
    mTimestamp = timestamp;
    mHorizontalAccuracy = horizontalAccuracy;
    mVerticalAccuracy = verticalAccuracy;
  }
}
