package io.maxads.ads.base.api;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class AdRequestParameters {
  @NonNull public static final AdRequestParameters EMPTY_PARAMETERS = new Builder().build();
  @Nullable private final Integer mPriceFloorCents;

  public AdRequestParameters(@NonNull Integer priceFloorCents) {
    mPriceFloorCents = priceFloorCents;
  }

  @Nullable
  public Integer getPriceFloorCents() {
    return mPriceFloorCents;
  }

  public static class Builder {
    @Nullable private Integer mPriceFloorCents;

    @NonNull
    public Builder withPriceFloorCents(@Nullable Integer priceFloorCents) {
      mPriceFloorCents = priceFloorCents;
      return this;
    }

    @NonNull
    public AdRequestParameters build() {
      return new AdRequestParameters(mPriceFloorCents);
    }
  }
}
