package io.maxads.ads.base;

import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;

class ModuleInitializationStateManager {
  @NonNull private final List<ModuleInitializationState> mModuleInitializationStateList;

  ModuleInitializationStateManager() {
    mModuleInitializationStateList = new ArrayList<>();
  }

  public void registerModuleInitializationState(@NonNull ModuleInitializationState moduleInitializationState) {
    mModuleInitializationStateList.add(moduleInitializationState);
  }

  public boolean areModulesInitialized() {
    for (ModuleInitializationState moduleInitializationState : mModuleInitializationStateList) {
      if (!moduleInitializationState.isInitialized()) {
        moduleInitializationState.logUnitializedError();
        return false;
      }
    }

    return true;
  }
}
