package io.maxads.ads.banner.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.FrameLayout;

import io.maxads.ads.banner.controller.BannerController;
import io.maxads.ads.base.api.AdRequestParameters;
import io.maxads.ads.base.api.MaxRequestManager;
import io.maxads.ads.base.model.Ad;

/**
 * This class is made as small as possible so that controller logic can more easily be tested in BannerController. We
 * interface with this controller logic through the view so that publishers only have to call into a single class
 * when integrating.
 */
public class MaxBannerAdView extends FrameLayout implements MaxRequestManager.RequestListener {

  public interface Listener {
    void onBannerLoaded(@NonNull MaxBannerAdView maxBannerAdView);
    void onBannerClicked(@NonNull MaxBannerAdView maxBannerAdView);
    void onBannerError(@NonNull MaxBannerAdView maxBannerAdView);
  }

  @NonNull private final BannerController mBannerController;

  public MaxBannerAdView(@NonNull Context context) {
    this(context, null);
  }

  public MaxBannerAdView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    mBannerController = new BannerController(context, this);

    setHorizontalScrollBarEnabled(false);
    setVerticalScrollBarEnabled(false);
  }

  public void setListener(@Nullable Listener listener) {
    mBannerController.setListener(listener);
  }

  public void setRequestListener(@Nullable MaxRequestManager.RequestListener listener) {
    mBannerController.setRequestListener(listener);
  }

  public void load(@NonNull String adUnitId) {
    load(adUnitId, AdRequestParameters.EMPTY_PARAMETERS);
  }

  public void load(@NonNull String adUnitId, @NonNull AdRequestParameters adRequestParameters) {
    mBannerController.load(adUnitId, adRequestParameters);
  }

  public void startRefreshTimer(long delaySeconds) {
    mBannerController.startRefreshTimer(delaySeconds);
  }

  /**
   * Default value is false
   */
  public void disableAutoRefresh(boolean disableAutoRefresh) {
    mBannerController.disableAutoRefresh(disableAutoRefresh);
  }

  public void destroy() {
    removeAllViews();
    mBannerController.destroy();
  }

  @Override
  public void onRequestSuccess(@NonNull Ad ad) {
    mBannerController.onRequestSuccess(ad);
  }

  @Override
  public void onRequestFail(@NonNull Throwable throwable) {
    mBannerController.onRequestFail(throwable);
  }
}
