package io.maxads.ads.banner;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;

import java.util.Map;

import io.maxads.ads.base.MaxAds;
import io.maxads.ads.base.model.Ad;
import io.maxads.ads.base.model.Winner;
import io.maxads.ads.base.util.MaxAdsLog;

public class BannerDecoratorFactory {
  @NonNull private static final String TAG = BannerDecoratorFactory.class.getSimpleName();

  @NonNull private final Context mContext;
  @NonNull private final Map<String, BannerFactory> mPartnerBannerFactories;

  public BannerDecoratorFactory(@NonNull Context context) {
    this(context, MaxAds.getPartnerBannerFactories());
  }

  @VisibleForTesting
  BannerDecoratorFactory(@NonNull Context context, @NonNull Map<String, BannerFactory> partnerBannerFactories) {
    mContext = context;
    mPartnerBannerFactories = partnerBannerFactories;
  }

  @Nullable
  public BannerDecorator createBanner(@NonNull Ad ad, @NonNull BannerDecorator.Listener listener) {
    final Banner banner;

    final Winner winner = ad.getWinner();
    if (winner.usePartnerRendering()) {
      banner = fromPartnerBannerFactories(winner.getPartner(), ad);
    } else {
      banner = fromCreativeType(ad.getWinner().getCreativeType(), ad);
    }

    if (banner == null) {
      return null;
    }

    final BannerDecorator bannerDecorator = new BannerDecorator(banner, ad);
    bannerDecorator.setListener(listener);
    return bannerDecorator;
  }

  @Nullable
  @VisibleForTesting
  Banner fromPartnerBannerFactories(@Nullable String partner, @NonNull Ad ad) {
    if (!mPartnerBannerFactories.containsKey(partner)) {
      MaxAdsLog.e(TAG, "Did not find a valid partner BannerFactory for partner: " + partner);
      return null;
    }

    return mPartnerBannerFactories.get(partner).createBanner(ad);
  }

  @Nullable
  @VisibleForTesting
  Banner fromCreativeType(@NonNull Winner.CreativeType creativeType, @NonNull Ad ad) {
    switch (creativeType) {
      case HTML: {
        return new MraidBanner(mContext, ad);
      }
      case EMPTY: {
        MaxAdsLog.d(TAG, "No ads found for for ad unit id: " + ad.getAdUnitId());
        return null;
      }
      default: {
        MaxAdsLog.e(TAG, "Incompatible creative type: " + creativeType + ", for banner ad format.");
        return null;
      }
    }
  }
}
