package io.maxads.adcolony;

import android.content.Context;
import android.support.annotation.NonNull;

import java.util.Map;

import io.maxads.ads.banner.BannerFactory;
import io.maxads.ads.base.ModuleInitializationStateManager;
import io.maxads.ads.base.api.TokenManager;
import io.maxads.ads.base.util.MaxAdsLog;
import io.maxads.ads.interstitial.InterstitialFactory;

public class MaxAdColony {
  @NonNull private static final String TAG = MaxAdColony.class.getSimpleName();
  @NonNull private static final String ADCOLONY_PARTNER_ID = "adcolony";

  public static void initialize(@NonNull Context context,
                                @NonNull ModuleInitializationStateManager moduleInitializationStateManager,
                                @NonNull TokenManager tokenManager,
                                @NonNull Map<String, BannerFactory> partnerBannerFactories,
                                @NonNull Map<String, InterstitialFactory> partnerInterstitialFactories) {
    moduleInitializationStateManager.registerModuleInitializationState(new AdColonyInitializationState());
    tokenManager.registerTokenProvider(new AdColonyTokenProvider());
    partnerInterstitialFactories.put(ADCOLONY_PARTNER_ID, new AdColonyInterstitialFactory());
    MaxAdsLog.d(TAG, "Successfully integrated and initialized max-adcolony module");
  }
}
