package io.maxads.adcolony;

import android.content.Context;
import android.support.annotation.NonNull;

import io.maxads.ads.base.MaxAds;
import io.maxads.ads.base.util.MaxAdsLog;

public class MaxAdColony {
  @NonNull private static final String TAG = MaxAdColony.class.getSimpleName();
  @NonNull private static final String ADCOLONY_PARTNER_ID = "adcolony";

  public static void initialize(@NonNull Context context) {
    MaxAds.registerTokenProvider(new AdColonyTokenProvider());
    MaxAds.registerInterstitialFactory(ADCOLONY_PARTNER_ID, new AdColonyInterstitialFactory());
    MaxAds.registerModuleInitializationState(new AdColonyInitializationState());
    MaxAdsLog.d(TAG, "Successfully integrated and initialized max-adcolony module");
  }
}
