package io.maxads.adcolony;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.adcolony.sdk.AdColony;
import com.adcolony.sdk.AdColonyInterstitialListener;
import com.adcolony.sdk.AdColonyZone;

import io.maxads.ads.base.model.Ad;
import io.maxads.ads.interstitial.Interstitial;

public class AdColonyInterstitial extends AdColonyInterstitialListener implements Interstitial {
  @NonNull private static final String TAG = AdColonyInterstitial.class.getSimpleName();

  @NonNull private final Ad mAd;

  @Nullable private com.adcolony.sdk.AdColonyInterstitial mAdColonyInterstitial;
  @Nullable private Interstitial.Listener mListener;

  public AdColonyInterstitial(@NonNull Ad ad) {
    mAd = ad;
  }

  @Override
  public void setListener(@Nullable Listener listener) {
    mListener = listener;
  }

  @Override
  public void load() {
    AdColony.requestInterstitial(mAd.getWinner().getPartnerPlacementId(), this);
  }

  @Override
  public void show() {
    if (mAdColonyInterstitial != null) {
      mAdColonyInterstitial.show();
    }
  }

  @Override
  public void destroy() {
    if (mAdColonyInterstitial != null) {
      mAdColonyInterstitial.destroy();
    }

    mListener = null;
  }

  // AdColonyInterstitialListener

  @Override
  public void onRequestFilled(com.adcolony.sdk.AdColonyInterstitial adColonyInterstitial) {
    mAdColonyInterstitial = adColonyInterstitial;
    if (mListener != null) {
      mListener.onInterstitialLoaded(this);
    }
  }

  @Override
  public void onRequestNotFilled(AdColonyZone zone) {
    super.onRequestNotFilled(zone);
    if (mListener != null) {
      mListener.onInterstitialFailedToLoad(this);
    }
  }

  @Override
  public void onOpened(com.adcolony.sdk.AdColonyInterstitial ad) {
    super.onOpened(ad);
    if (mListener != null) {
      mListener.onInterstitialShown(this);
      mListener.onInterstitialImpressed(this);
    }
  }

  @Override
  public void onClosed(com.adcolony.sdk.AdColonyInterstitial ad) {
    super.onClosed(ad);
    if (mListener != null) {
      mListener.onInterstitialDismissed(this);
    }
  }

  @Override
  public void onExpiring(com.adcolony.sdk.AdColonyInterstitial ad) {
    super.onExpiring(ad);
    if (mListener != null) {
      mListener.onInterstitialDidExpire(this);
    }
  }

  @Override
  public void onClicked(com.adcolony.sdk.AdColonyInterstitial ad) {
    super.onClicked(ad);
    if (mListener != null) {
      mListener.onInterstitialClicked(this);
    }
  }
}
