package io.maxads.adcolony;

import android.text.TextUtils;

import com.adcolony.sdk.AdColony;

import io.maxads.ads.base.ModuleInitializationState;
import io.maxads.ads.base.util.MaxAdsLog;

public class AdColonyInitializationState implements ModuleInitializationState {
  private static final String TAG = AdColonyInitializationState.class.getSimpleName();

  @Override
  public boolean isInitialized() {
    // The SDK version will be empty if AdColony#configure has not been called
    return !TextUtils.isEmpty(AdColony.getSDKVersion());
  }

  @Override
  public void logUnitializedError() {
    MaxAdsLog.e(TAG, "AdColony SDK has not been initialized. " +
      "Please call AdColony#configure in your main activity's onCreate method.");
  }
}
