/*
 * Decompiled with CFR 0.152.
 */
package io.manycore.maven;

import java.io.File;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.json.JSONObject;

@Mojo(name="refrem-build", defaultPhase=LifecyclePhase.PACKAGE)
public class RefremMavenPlugin
extends AbstractMojo {
    @Parameter(property="refrem-build.accessToken")
    private String accessToken;
    @Parameter(property="refrem-build.companyId")
    private int companyId;
    @Parameter(property="refrem-build.mainClass")
    private String mainClass;
    @Parameter(property="refrem-build.uploadEndpoint")
    private String uploadEndpoint;
    @Parameter(property="project", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Refrem Maven Plugin is starting...");
        String pomFileName = this.project.getBasedir().toString() + File.separator + "pom.xml";
        String jarFileName = this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + ".jar";
        this.getLog().info((CharSequence)("Uploading " + pomFileName));
        this.getLog().info((CharSequence)("...and " + jarFileName));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpEntity data = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("pom", new File(pomFileName), ContentType.APPLICATION_XML, "pom.xml").addBinaryBody("jar", new File(jarFileName), ContentType.DEFAULT_BINARY, this.project.getBuild().getFinalName() + ".jar").addTextBody("cid", "" + this.companyId).addTextBody("token", this.accessToken).addTextBody("mainClass", this.mainClass).build();
            HttpUriRequest request = RequestBuilder.post((String)this.uploadEndpoint).setEntity(data).build();
            ResponseHandler responseHandler = response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            };
            String responseBody = (String)httpclient.execute(request, responseHandler);
            JSONObject obj = new JSONObject(responseBody);
            if (obj.getBoolean("success")) {
                this.getLog().info((CharSequence)("Successfully uploaded jar+pom to Refrem: " + obj.getString("message")));
            } else {
                this.getLog().error((CharSequence)("Failed to upload jar+pom to Refrem: " + obj.getString("message")));
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error: " + e.toString()));
        }
    }
}

