/*
 * Decompiled with CFR 0.152.
 */
package io.magus.methodmap.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.magus.methodmap.ArgsFactory;
import io.magus.methodmap.MethodHandleInfo;
import io.magus.methodmap.error.ArgsProductionException;
import java.io.IOException;
import java.lang.reflect.Type;

public class JacksonArgsFactory
implements ArgsFactory {
    private final ObjectMapper objectMapper;
    private final ArrayNode jsonArgsArray;

    public JacksonArgsFactory(ObjectMapper objectMapper, ArrayNode jsonArgsArray) {
        this.objectMapper = objectMapper;
        this.jsonArgsArray = jsonArgsArray;
    }

    public JacksonArgsFactory(ObjectMapper objectMapper, String jsonArrayString) throws JsonParseException, JsonMappingException, IOException {
        this(objectMapper, (ArrayNode)objectMapper.readValue(jsonArrayString, ArrayNode.class));
    }

    @Override
    public Object[] produceArgs(MethodHandleInfo methodHandleInfo) throws ArgsProductionException {
        Type[] parameterTypes = methodHandleInfo.getMethod().getGenericParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        int numJsonArgs = this.jsonArgsArray.size();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object arg;
            JavaType javaType = this.objectMapper.constructType(parameterTypes[i]);
            args[i] = arg = i < numJsonArgs ? this.objectMapper.convertValue((Object)this.jsonArgsArray.get(i), javaType) : null;
        }
        return args;
    }
}

