/*
 * Decompiled with CFR 0.152.
 */
package io.magus.methodmap;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class MethodHandleInfo {
    private final Object target;
    private final Method method;
    private final MethodHandles.Lookup lookup;
    private final MethodHandle methodHandle;
    private final int modifiers;

    public MethodHandleInfo(Object target, Method method, MethodHandles.Lookup lookup) throws IllegalAccessException {
        this.target = target;
        this.method = method;
        this.lookup = lookup;
        MethodHandle tempHandle = lookup.unreflect(method);
        this.modifiers = method.getModifiers();
        if (target != null && !Modifier.isStatic(this.modifiers)) {
            tempHandle = tempHandle.bindTo(target);
        }
        if (method.isVarArgs()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            tempHandle = tempHandle.asVarargsCollector(paramTypes[paramTypes.length - 1]);
        }
        this.methodHandle = tempHandle;
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodHandles.Lookup getLookup() {
        return this.lookup;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Object invoke(Object ... args) throws Throwable {
        Object result;
        if (this.method.isVarArgs()) {
            if (Modifier.isStatic(this.modifiers)) {
                result = this.methodHandle.invokeWithArguments(args);
            } else if (args == null) {
                result = this.methodHandle.invokeWithArguments(args);
            } else {
                Object target = null;
                Object[] methodArgs = null;
                if (args.length >= 1) {
                    target = args[0];
                }
                if (args.length > 1) {
                    methodArgs = Arrays.copyOfRange(args, 1, args.length);
                }
                result = this.method.invoke(target, methodArgs);
            }
        } else {
            result = this.methodHandle.invokeWithArguments(args);
        }
        return result;
    }
}

