/*
 * Decompiled with CFR 0.152.
 */
package io.magus.methodmap;

import io.magus.methodmap.MapEntryKeyFactory;
import io.magus.methodmap.MethodHandleInfo;
import io.magus.methodmap.error.MapEntryKeyProductionException;
import java.lang.reflect.Method;

public class FullSignatureEntryKeyFactory
implements MapEntryKeyFactory<String> {
    private final String signatureComponentSeparator;

    public FullSignatureEntryKeyFactory(String signatureComponentSeparator) {
        this.signatureComponentSeparator = signatureComponentSeparator;
    }

    public String[] produceMapEntryKeys(MethodHandleInfo methodHandleInfo) throws MapEntryKeyProductionException {
        Class<?>[] parameterTypes;
        Method method = methodHandleInfo.getMethod();
        Class<?> clazz = method.getDeclaringClass();
        String className = clazz.getName();
        String methodName = method.getName();
        int keyLength = className.length() + methodName.length() + 1;
        for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
            keyLength += parameterType.getName().length() + 1;
        }
        StringBuilder stringBuilder = new StringBuilder(keyLength).append(className).append(this.signatureComponentSeparator).append(methodName);
        for (Class<?> parameterType : parameterTypes) {
            stringBuilder.append(this.signatureComponentSeparator).append(parameterType.getName());
        }
        return new String[]{stringBuilder.toString()};
    }
}

