/*
 * Decompiled with CFR 0.152.
 */
package io.magus.methodmap;

import io.magus.methodmap.AbstractMethodMap;
import io.magus.methodmap.ArgsFactory;
import io.magus.methodmap.KeyArgsPair;
import io.magus.methodmap.MapEntryKeyFactory;
import io.magus.methodmap.MethodCollectionFactory;
import io.magus.methodmap.MethodHandleInfo;
import io.magus.methodmap.error.ArgsProductionException;
import io.magus.methodmap.error.DuplicateKeyException;
import io.magus.methodmap.error.InvocationException;
import io.magus.methodmap.error.MapEntryKeyProductionException;
import io.magus.methodmap.error.MethodCollectionProductionException;
import io.magus.methodmap.error.UnmappedKeyException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class AutoInstantiatingMethodMap<K>
extends AbstractMethodMap<K> {
    private static final long serialVersionUID = 4325779650129661784L;

    public AutoInstantiatingMethodMap(MapEntryKeyFactory<K> entryKeyFactory, MethodCollectionFactory methodCollectionFactory, MethodHandles.Lookup lookup) throws DuplicateKeyException, MethodCollectionProductionException, IllegalAccessException, MapEntryKeyProductionException {
        super(null, methodCollectionFactory.produceMethodCollection(), entryKeyFactory, lookup);
    }

    protected Object invoke(MethodHandleInfo methodHandleInfo, Class<?>[] constructorParameterTypes, Object[] constructorArgs, Object ... args) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InvocationException {
        Object[] invokeArgs;
        if (!Modifier.isStatic(methodHandleInfo.getModifiers())) {
            Constructor<?> constructor = methodHandleInfo.getMethod().getDeclaringClass().getConstructor(constructorParameterTypes);
            Object instance = constructor.newInstance(constructorArgs);
            int argsLength = args == null ? 0 : args.length;
            invokeArgs = new Object[argsLength + 1];
            int i = 0;
            invokeArgs[i++] = instance;
            if (args != null) {
                for (Object arg : args) {
                    invokeArgs[i++] = arg;
                }
            }
        } else {
            invokeArgs = args;
        }
        return super.invoke(methodHandleInfo, invokeArgs);
    }

    protected Object invoke(MethodHandleInfo methodHandleInfo, Class<?>[] constructorParameterTypes, Object[] constructorArgs, ArgsFactory argsFactory) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ArgsProductionException, InvocationException {
        return this.invoke((K)methodHandleInfo, constructorParameterTypes, constructorArgs, argsFactory.produceArgs(methodHandleInfo));
    }

    @Override
    protected Object invoke(MethodHandleInfo methodHandleInfo, Object ... args) throws InvocationException {
        try {
            return this.invoke((K)methodHandleInfo, (Class<?>[])null, (Object[])null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvocationException(e);
        }
    }

    @Override
    protected Object invoke(MethodHandleInfo methodHandleInfo, ArgsFactory argsFactory) throws ArgsProductionException, InvocationException {
        try {
            return this.invoke((K)methodHandleInfo, null, null, argsFactory);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvocationException(e);
        }
    }

    public Object invoke(K key, Class<?>[] constructorParameterTypes, Object[] constructorArgs, Object ... args) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, UnmappedKeyException, InvocationException {
        return this.invoke((K)this.getMethodHandleInfo(key), constructorParameterTypes, constructorArgs, args);
    }

    public Object invoke(K key, Class<?>[] constructorParameterTypes, Object[] constructorArgs, ArgsFactory argsFactory) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ArgsProductionException, UnmappedKeyException, InvocationException {
        return this.invoke((K)this.getMethodHandleInfo(key), constructorParameterTypes, constructorArgs, argsFactory);
    }

    @Override
    public Object invoke(K key, Object ... args) throws UnmappedKeyException, InvocationException {
        try {
            return this.invoke(key, (Class<?>[])null, (Object[])null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvocationException(e);
        }
    }

    @Override
    public Object invoke(K key, ArgsFactory argsFactory) throws UnmappedKeyException, ArgsProductionException, InvocationException {
        try {
            return this.invoke(key, null, null, argsFactory);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvocationException(e);
        }
    }

    @Override
    public Object invoke(Object ... args) throws UnmappedKeyException, InvocationException {
        KeyArgsPair keyArgsPair = new KeyArgsPair(args);
        try {
            return this.invoke(keyArgsPair.getKey(), (Class<?>[])null, (Object[])null, keyArgsPair.getArgs());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvocationException(e);
        }
    }
}

