/*
 * Decompiled with CFR 0.152.
 */
package io.magus.methodmap;

import io.magus.methodmap.ArgsFactory;
import io.magus.methodmap.MapEntryKeyFactory;
import io.magus.methodmap.MethodHandleInfo;
import io.magus.methodmap.error.ArgsProductionException;
import io.magus.methodmap.error.DuplicateKeyException;
import io.magus.methodmap.error.InvocationException;
import io.magus.methodmap.error.MapEntryKeyProductionException;
import io.magus.methodmap.error.UnmappedKeyException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;

public abstract class AbstractMethodMap<K>
extends HashMap<K, MethodHandleInfo> {
    private static final long serialVersionUID = -3499174659234956205L;

    protected AbstractMethodMap(Object target, Collection<Method> methods, MapEntryKeyFactory<K> entryKeyFactory, MethodHandles.Lookup lookup) throws DuplicateKeyException, IllegalAccessException, MapEntryKeyProductionException {
        if (methods != null) {
            for (Method method : methods) {
                MethodHandleInfo newMethodHandleInfo = new MethodHandleInfo(target, method, lookup);
                K[] producedEntryKeys = entryKeyFactory.produceMapEntryKeys(newMethodHandleInfo);
                if (producedEntryKeys == null) continue;
                for (K producedEntryKey : producedEntryKeys) {
                    MethodHandleInfo mappedMethodHandleInfo = (MethodHandleInfo)this.get(producedEntryKey);
                    if (mappedMethodHandleInfo != null) {
                        throw new DuplicateKeyException(Objects.toString(producedEntryKey));
                    }
                    this.put(producedEntryKey, newMethodHandleInfo);
                }
            }
        }
    }

    public MethodHandleInfo getMethodHandleInfo(K key) throws UnmappedKeyException {
        MethodHandleInfo result = (MethodHandleInfo)this.get(key);
        if (result == null) {
            throw new UnmappedKeyException(Objects.toString(key));
        }
        return result;
    }

    protected Object invoke(MethodHandleInfo methodHandleInfo, Object ... args) throws InvocationException {
        try {
            return methodHandleInfo.invoke(args);
        }
        catch (Throwable e) {
            throw new InvocationException(e);
        }
    }

    protected Object invoke(MethodHandleInfo methodHandleInfo, ArgsFactory argsFactory) throws ArgsProductionException, InvocationException {
        return this.invoke(methodHandleInfo, argsFactory.produceArgs(methodHandleInfo));
    }

    public abstract Object invoke(K var1, Object ... var2) throws UnmappedKeyException, InvocationException;

    public abstract Object invoke(K var1, ArgsFactory var2) throws UnmappedKeyException, ArgsProductionException, InvocationException;

    public abstract Object invoke(Object ... var1) throws UnmappedKeyException, InvocationException;
}

