package io.magus.methodmap.error;

/**
 * Exception used to indicate that there is no method mapped to a given key for invocations of
 * {@link io.magus.methodmap.AbstractMethodMap#getMethodHandleInfo(Object)}.
 *
 * @author Enseart A. Simpson
 *
 */
public class UnmappedKeyException extends Exception {

	private static final long serialVersionUID = -7285148151631983589L;

	public UnmappedKeyException() {
		super();
	}

	public UnmappedKeyException(String message) {
		super(message);
	}

	public UnmappedKeyException(String message, Throwable cause) {
		super(message, cause);
	}

	public UnmappedKeyException(String message, Throwable cause,
			boolean enableSuppression, boolean writableStackTrace) {
		super(message);
	}

	public UnmappedKeyException(Throwable cause) {
		super(cause);
	}
}