package io.magus.methodmap.error;

/**
 * Exception used to indicate that a {@link io.magus.methodmap.MethodCollectionFactory} could not
 * produce a method collection.
 *
 * @author Enseart A. Simpson
 *
 */
public class MethodCollectionProductionException extends Exception {

	private static final long serialVersionUID = 7749805406282107224L;

	public MethodCollectionProductionException() {
		super();
	}

	public MethodCollectionProductionException(String message) {
		super(message);
	}

	public MethodCollectionProductionException(String message, Throwable cause) {
		super(message, cause);
	}

	public MethodCollectionProductionException(String message, Throwable cause,
			boolean enableSuppression, boolean writableStackTrace) {
		super(message);
	}

	public MethodCollectionProductionException(Throwable cause) {
		super(cause);
	}
}