package io.magus.methodmap.error;

/**
 * Exception used to indicate that a call to {@code invoke} has failed for subclasses of
 * {@link io.magus.methodmap.AbstractMethodMap}.
 *
 * @author Enseart A. Simpson
 *
 */
public class InvocationException extends Exception {

    private static final long serialVersionUID = 596839765610496675L;

    public InvocationException() {
        super();
    }

    public InvocationException(String message) {
        super(message);
    }

    public InvocationException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvocationException(String message, Throwable cause,
            boolean enableSuppression, boolean writableStackTrace) {
        super(message);
    }

    public InvocationException(Throwable cause) {
        super(cause);
    }
}
