package io.magus.methodmap.error;

/**
 * Exception used to indicate that a new method mapping was attempted under an existing entry key
 * for an implementation of {@link io.magus.methodmap.AbstractMethodMap}.
 *
 * @author Enseart A. Simpson
 *
 */
public class DuplicateKeyException extends Exception {

	private static final long serialVersionUID = 2737586928153705761L;

	public DuplicateKeyException() {
		super();
	}

	public DuplicateKeyException(String message) {
		super(message);
	}

	public DuplicateKeyException(String message, Throwable cause) {
		super(message, cause);
	}

	public DuplicateKeyException(String message, Throwable cause,
			boolean enableSuppression, boolean writableStackTrace) {
		super(message);
	}

	public DuplicateKeyException(Throwable cause) {
		super(cause);
	}
}