package io.magus.methodmap.domain.error;

/**
 * Exception used to indicate that there is no methodmap mapped to a given domain for invocations of
 * {@link io.magus.methodmap.domain.MethodMapDomain#getMethodMap(Object)};
 *
 * @author Enseart A. Simpson
 *
 */
public class UnmappedDomainException extends Exception {

	private static final long serialVersionUID = -4858971688939200914L;

	public UnmappedDomainException() {
		super();
	}

	public UnmappedDomainException(String message) {
		super(message);
	}

	public UnmappedDomainException(String message, Throwable cause) {
		super(message, cause);
	}

	public UnmappedDomainException(String message, Throwable cause,
			boolean enableSuppression, boolean writableStackTrace) {
		super(message);
	}

	public UnmappedDomainException(Throwable cause) {
		super(cause);
	}
}
